# Guia Passo a Passo para Implementação do Transcritor de Anamnese em Tempo Real

Este guia simplificado explica como implementar e executar o transcritor de anamnese com transcrição em tempo real.

## Pré-requisitos

- Node.js instalado (versão 14 ou superior)
- NPM (gerenciador de pacotes do Node.js)
- Chave de API da OpenAI

## Passo 1: Configurar o Servidor

1. Abra um terminal e navegue até a pasta do servidor:
   ```bash
   cd transcritor-tempo-real/server
   ```

2. Instale as dependências necessárias:
   ```bash
   npm install
   ```

3. Edite o arquivo `.env` e adicione sua chave de API da OpenAI:
   ```
   OPENAI_API_KEY=sua_chave_api_aqui
   PORT=3000
   ```

4. Crie uma pasta para os uploads temporários:
   ```bash
   mkdir uploads
   ```

5. Inicie o servidor:
   ```bash
   node server.js
   ```

   Você deverá ver a mensagem: `Servidor rodando na porta 3000`

## Passo 2: Acessar a Aplicação

1. Abra seu navegador e acesse:
   ```
   http://localhost:3000
   ```

2. Você verá a interface do transcritor de anamnese com três abas:
   - **Anamnese Estruturada**: Mostra o texto organizado em formato de anamnese
   - **Transcrição Completa**: Mostra o texto bruto transcrito
   - **Contexto Clínico**: Permite adicionar informações de contexto

## Passo 3: Usar o Transcritor

1. Clique no botão **Gravar** para iniciar a transcrição em tempo real
2. Fale normalmente - você verá o texto aparecendo enquanto fala
3. A anamnese estruturada será atualizada automaticamente a cada 15 segundos
4. Clique em **Parar** quando terminar
5. Use o botão **Copiar** para copiar o texto da aba atual
6. Use o botão **Limpar** para limpar todos os campos de texto

## Solução de Problemas Comuns

### Erro de conexão com o servidor
- Verifique se o servidor está rodando na porta 3000
- Verifique se não há outro serviço usando a mesma porta

### Erro ao acessar o microfone
- Certifique-se de que o navegador tem permissão para acessar o microfone
- Tente usar o Chrome, que tem melhor suporte para APIs de áudio

### Erro na transcrição
- Verifique se a chave da API da OpenAI está correta no arquivo .env
- Verifique se há créditos suficientes na sua conta da OpenAI

### Latência alta
- Reduza o tamanho dos chunks de áudio (altere o valor no MediaRecorder.start())
- Verifique sua conexão com a internet

## Personalização Rápida

### Alterar o intervalo de atualização da anamnese estruturada
No arquivo `server.js`, localize a linha:
```javascript
if (Date.now() - session.lastOrganizeTime > 15000 || !session.lastOrganizeTime) {
```
E altere `15000` (15 segundos) para o valor desejado em milissegundos.

### Alterar o tamanho dos chunks de áudio
No arquivo `script.js`, localize a linha:
```javascript
mediaRecorder.start(1000); // Capturar chunks a cada 1 segundo
```
E altere `1000` (1 segundo) para o valor desejado em milissegundos.

### Alterar o modelo de IA
No arquivo `server.js`, localize a linha:
```javascript
model: 'o3-mini',
```
E altere para outro modelo disponível na OpenAI, como `gpt-3.5-turbo` ou `gpt-4`.
